import groovy.json.JsonSlurper
import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*
/**
 * WebResource extractor plugin for castalba.tv
 * 
 * @author jhb50
 * Version 1 - 5/01/2012
 * Version 2 - 7/27/2012 - Update URI address & move url get logic
 * Version 3 - 8/13/2012 - Add version logging
 * Version 4 - 2/09/2013 - new IP
 * Version 5 - 4/27/2013 - sort Channel Titles
 *
 * Usage: http://www.castalba.tv
 * Optional Parameter refresh=nn
 *
 *
 */
class Castalba extends WebResourceUrlExtractor {
	
	final VALID_FEED_URL = '^(?:https?://)?(?:www\\.)?castalba\\.tv/channels.*?'
	
	String getExtractorName() {
		return 'Castalba'
	}

	boolean extractorMatches(URL feedUrl) {
		return feedUrl ==~ VALID_FEED_URL
	}
	
	int getVersion() {
		return 5
	}

	Boolean URLExists(URL fileURL){
		if(((HttpURLConnection) fileURL.openConnection()).getResponseCode() == 404){
			return false
		}
		return true
	}

	WebResourceContainer extractItems(URL resourceUrl, int maxItems) {

		log("Parsing with Castalba V${getVersion()}")
		
		List<WebResourceItem> items = []
		def itemsAdded = 0;

		long Refreshi = (30*24*60)
		String secCode
		String thumbUrl
		String videoTitle
		
		def parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?castalba\\.to/.*?refresh=(.+)'
		def parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?castalba\\.to/.*?refresh=[0-9]+'
		if (parmMatch){
			Refreshi = parmMatcher[0][1].trim().toLong()
		}

		String maskUrl = "http://www.castalba.tv/channels/p="
		String pageUrl = maskUrl +"1"
		String html = new URL(pageUrl).getText()

		def pageMatcher = html =~ '(?s)<h2>Live Channels</h2>.*?<ul>(.*?)</ul>'
		String page = pageMatcher[0][1]
		if (page.size() < 80){
		    println "No items - returning"
			return null
		}
		def titleMatcher = html =~ '(?s)<h2>(.*?)</h2>'
		String pageTitle = titleMatcher[0][1].trim()
		println "\npagetitle = $pageTitle"
		String pageThumb = "http://www.castalba.to/images/channel.gif"
		
		for( int j = 2; j < 10; j++) {
			def videoMatcher = page =~ '(?s)<li>.*?<a.href="..(.*?)".*?<img.src="..(.*?)".*?<span class="time">(.*?)<.*?<h4>.*?>(.*?)</a></h4>.*?'
			for( int i = 0; i < videoMatcher.size() && (maxItems == -1 || itemsAdded < maxItems); i++ ) {
				
				if (videoMatcher[i][3].trim() != "Live") continue

				videoTitle = videoMatcher[i][4].trim()
				
				String linkUrl = "http://www.castalba.tv" + videoMatcher[i][1].trim()
				
				String Image = videoMatcher[i][2].trim()
				thumbUrl = "http://castalba.tv" + Image

				log("ADDED $videoTitle - $linkUrl")

				WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'secCode':secCode,'linkUrl':linkUrl,'thumbUrl':thumbUrl,'refreshi':Refreshi])
				items << item
				itemsAdded++			
			}

			String npageUrl = maskUrl + j
			println npageUrl
			if (URLExists(new URL(npageUrl))){
				html = new URL(npageUrl).getText()
			
				pageMatcher = html =~ '(?s)<h2>Live Channels</h2>.*?<ul>(.*?)</ul>'
				String npage = pageMatcher[0][1]

				if (npage == page) break
				else page = npage

				if (page.size() < 80){
					println "No items - returning"
					break
				}
			}
			else break
		}
		items = items.sort{it.title}

		def actRefreshat
		if (Refreshi == (30*24*60)){
			log ("Castalba Folder Refresh Set to Console Default")
            actRefreshat = "Console Default time"
		}
		else{
			long curTime = System.currentTimeMillis()/60000
			long actRefresha = curTime + Refreshi 
			actRefreshat = new Date(actRefresha*60000).format("H:mm 'on' E M/dd/yyyy ").trim()
			log ("Castalba Expiry Set to " + actRefreshat )
		}

		if (itemsAdded == 0 ){
			linkUrl = "http://lastitem"
			secCode = "abcdefghi"
			thumbUrl = "https://sites.google.com/site/serviiorss/noevents.jpg"
			videoTitle = "Next Refresh at $actRefreshat"
			log ("ADDED 'NO EVENTS ITEM'")
			WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'secCode':secCode,'linkUrl':linkUrl,'thumbUrl':thumbUrl,'refreshi':Refreshi])

			items << item

		}
		
		return new WebResourceContainer(title: pageTitle, thumbnailUrl: pageThumb, items: items)
	}
	
	ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality) {		
		String linkUrl = item.getAdditionalInfo()['linkUrl']
		assert linkUrl != null
		String thumbnailUrl = item.getAdditionalInfo()['thumbUrl']
		assert thumbnailUrl != null
		String rtmpUrl
		String linkHtml = new URL(linkUrl).getText()
		
		if (linkUrl.contains("http://lastitem")){
			rtmpUrl = "rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v00/reflector:53708"
		}
		else{
		
			def rtmpMatcher = linkHtml =~ /(?s).*?<script.type="text\\/javascript">.*?'file':.'(.*?)'.*?'streamer':.'(.*?)'.*?/
			def secCode = rtmpMatcher[0][1].trim()
			def link2Url = rtmpMatcher[0][2].trim()
			if (link2Url.contains("rtmp://live.castalba.tv")) link2Url = "rtmp://173.192.48.117/live"  
			rtmpUrl = link2Url + "/" + secCode + " swfUrl=http://static.castalba.tv/player.swf pageURL=http://castalba.tv swfVfy=0 live=1"
		}
		println "rtmpUrl = $rtmpUrl"

		String resourceUrl = item.getAdditionalInfo()['resourceUrl']
		String secCode = item.getAdditionalInfo()['secCode']
		def cacheKey = resourceUrl + "_" +  secCode
		long Refreshi = item.getAdditionalInfo()['refreshi']
		
		if (Refreshi == (30*24*60))
			return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: rtmpUrl, thumbnailUrl: thumbnailUrl, live: true, cacheKey: cacheKey)

		long curTime=System.currentTimeMillis()/60000
		long Refresha = curTime + Refreshi + 5
		Date setexpiryDate = new Date(Refresha*60000)

		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: rtmpUrl, thumbnailUrl: thumbnailUrl, live: true, expiresOn: setexpiryDate, cacheKey: cacheKey)
	}
	
	static void main(args) {
		Castalba extractor = new Castalba()		
		assert extractor.extractorMatches( new URL("http://www.castalba.tv/channels") )
		assert !extractor.extractorMatches( new URL("http://google.com/feeds/api/standardfeeds/top_rated?time=today") )
		WebResourceContainer container = extractor.extractItems( new URL("http://www.castalba.tv/channels"), -1)

		ContentURLContainer result = extractor.extractUrl(container.getItems()[1], PreferredQuality.MEDIUM)
		print result
	}
}
